#ifndef _DX_VOS_MOBILE_UTILS_H
#define _DX_VOS_MOBILE_UTILS_H

/*! \file DX_VOS_MobileUtils.h
This module provides Mobile devices information retrieval utilities.

All function can return one of the follwing values:
- DX_SUCCESS - if value was retrieved successfully.
- DX_BUFFER_IS_NOT_BIG_ENOUGH - if data could not fit supplied buffer.
- DX_VOS_MOBILE_UTILS_ERROR - if retrieval failed.
*/
#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C" {
#endif
/*!	Retrieves subscriber ID. */
DxStatus DX_VOS_GetCurrentIMSI(DxChar* aBuff, DxUint aBuffSize);

/*! Retrieves Device Manufacturer ID*/
DxStatus DX_VOS_GetDevManufacturerId(DxChar* aBuff, DxUint aBuffSize);

/*! Retrieves Device Model */
DxStatus DX_VOS_GetDevModel(DxChar* aBuff, DxUint aBuffSize);

/*! Retrieves Device Version */
DxStatus DX_VOS_GetDevVersion(DxChar* aBuff, DxUint aBuffSize);

#ifdef __cplusplus
}
#endif
#endif
